/*
* ldigest.h
* message digest library for Lua based on OpenSSL or Apple CommonDigest
* Luiz Henrique de Figueiredo <lhf@tecgraf.puc-rio.br>
* 07 Jun 2019 07:14:53
* This code is hereby placed in the public domain and also under the MIT license
*/

#ifdef __linux__
#include <openssl/opensslv.h>
#include <openssl/md4.h>
#include <openssl/md5.h>
#include <openssl/sha.h>
#define AUTHOR		OPENSSL_VERSION_TEXT
#endif

#ifdef __APPLE__
#define COMMON_DIGEST_FOR_OPENSSL
#include <CommonCrypto/CommonDigest.h>
#define AUTHOR		"Apple CommonDigest"
#endif

#define SHA1_CTX		SHA_CTX
#define SHA1_DIGEST_LENGTH	SHA_DIGEST_LENGTH
#define SHA224_CTX		SHA256_CTX
#define SHA384_CTX		SHA512_CTX

#ifndef MD2_DIGEST_LENGTH
#define populate_MD2(L,name)
#endif

#ifndef MD4_DIGEST_LENGTH
#define populate_MD4(L,name)
#endif

#ifndef MD5_DIGEST_LENGTH
#define populate_MD5(L,name)
#endif

#ifndef SHA1_DIGEST_LENGTH
#define populate_SHA1(L,name)
#endif

#ifndef SHA224_DIGEST_LENGTH
#define populate_SHA224(L,name)
#endif

#ifndef SHA256_DIGEST_LENGTH
#define populate_SHA256(L,name)
#endif

#ifndef SHA384_DIGEST_LENGTH
#define populate_SHA384(L,name)
#endif

#ifndef SHA512_DIGEST_LENGTH
#define populate_SHA512(L,name)
#endif

