/*
* template.c
* template for message digest library for Lua
* Luiz Henrique de Figueiredo <lhf@tecgraf.puc-rio.br>
* 27 Jul 2018 21:06:03
* This code is hereby placed in the public domain and also under the MIT license
*/

#ifndef REPEAT
#define REPEAT
#define CONCAT(x,y)	CONCAT_(x, y)
#define CONCAT_(x,y)	x ## y
#define STRING(s)	STRING_(s)
#define STRING_(s)	#s
#endif

#define D(x)		CONCAT(DIGEST,CONCAT(_,x))
#define F(x)		CONCAT(x,CONCAT(_,DIGEST))
#define MYTYPE		STRING(DIGEST) " digest"
#define N		D(DIGEST_LENGTH)

static D(CTX) *F(Pnew)(lua_State *L)
{
 D(CTX) *c=lua_newuserdata(L,sizeof(D(CTX)));
 luaL_setmetatable(L,MYTYPE);
 return c;
}

static D(CTX) *F(Pget)(lua_State *L, int i)
{
 return luaL_checkudata(L,i,MYTYPE);
}

static int F(Lnew)(lua_State *L)		/** new() */
{
 D(CTX) *c=F(Pnew)(L);
 D(Init)(c);
 return 1;
}

static int F(Lclone)(lua_State *L)		/** clone(c) */
{
 D(CTX) *c=F(Pget)(L,1);
 D(CTX) *d=F(Pnew)(L);
 *d=*c;
 return 1;
}

static int F(Lreset)(lua_State *L)		/** reset(c) */
{
 D(CTX) *c=F(Pget)(L,1);
 D(Init)(c);
 lua_settop(L,1);
 return 1;
}

static int F(Lupdate)(lua_State *L)		/** update(c,s,...) */
{
 D(CTX) *c=F(Pget)(L,1);
 int i,n=lua_gettop(L);
 for (i=2; i<=n; i++)
 {
  size_t l;
  const char *s=luaL_checklstring(L,i,&l);
  D(Update)(c,s,l);
 }
 lua_settop(L,1);
 return 1;
}

static void F(Pdigest)(lua_State *L, unsigned char digest[])
{
 if (lua_isuserdata(L,1))
 {
  D(CTX) *c=F(Pget)(L,1);
  D(Final)(digest,c);
 }
 else
 {
  size_t l;
  const char *s=luaL_checklstring(L,1,&l);
  D(CTX) c;
  D(Init)(&c);
  D(Update)(&c,s,l);
  D(Final)(digest,&c);
 }
}

static int F(Ldigest)(lua_State *L)		/** digest(c[s]) */
{
 unsigned char digest[N];
 F(Pdigest)(L,digest);
 lua_pushlstring(L,(char*)digest,sizeof(digest));
 return 1;
}

static int F(Lhexdigest)(lua_State *L)		/** hexdigest(c[s]) */
{
 unsigned char digest[N];
 const char *digit="0123456789abcdef";
 char hexdigest[2*N];
 int i,j;
 F(Pdigest)(L,digest);
 for (i=0, j=0; i<N; i++)
 {
  hexdigest[j++]=digit[digest[i] >> 4];
  hexdigest[j++]=digit[digest[i] & 0x0F];
 }
 lua_pushlstring(L,hexdigest,sizeof(hexdigest));
 return 1;
}

#if LUA_VERSION_NUM <= 502
static int F(Ltostring)(lua_State *L)
{
 lua_pushfstring(L,"%s: %p",MYTYPE,(void*)F(Pget)(L,1));
 return 1;
}
#define MYTOSTRING {"__tostring",F(Ltostring)},
#else
#define MYTOSTRING
#endif

static const luaL_Reg F(R)[] =
{
	MYTOSTRING
	{ "clone",	F(Lclone)	},
	{ "copy",	F(Lclone)	},
	{ "digest",	F(Ldigest)	},
	{ "hexdigest",	F(Lhexdigest)	},
	{ "new",	F(Lnew)		},
	{ "reset",	F(Lreset)	},
	{ "update",	F(Lupdate)	},
	{ NULL,		NULL	}
};

static void F(populate)(lua_State *L, const char *name)
{
 lua_pushstring(L,name);
 luaL_newmetatable(L,MYTYPE);
 luaL_setfuncs(L,F(R),0);
 lua_pushliteral(L,"__index");
 lua_pushvalue(L,-2);
 lua_settable(L,-3);
 lua_pushliteral(L,"name");
 lua_pushstring(L,name);
 lua_settable(L,-3);
 lua_pushliteral(L,"size");
 lua_pushinteger(L,N);
 lua_settable(L,-3);
 lua_settable(L,-3);
}

#undef DIGEST
#undef D
#undef F
#undef MYTYPE
#undef N
#undef MYTOSTRING
