-- test rational number library

local Q=require"qmath"
print(Q.version)

------------------------------------------------------------------------------
print""
print"E by series"
local d=40
local t=Q.new(1)
local s=t
local x=Q.new(1)
print(0,s:todecimal(d),s)
for n=1,20 do
	t=t*x/n
	s=s+t
	print(n,s:todecimal(d),s)
end
print("oo","2.7182818284590452353602874713526624977572")

------------------------------------------------------------------------------
print""
print"Continued fractions"

function CF(q)
	print(q)
	q=Q.new(q)
	print(q)
	io.write('[')
	local c=';'
	while true do
		local i=q:int()
		io.write(i:tostring(),c)
		q=q-i
		if q:iszero() then break end
		q=q:inv()
		c=','
	end
	io.write(']\n')
end

--CF("1.618033988749894848204586834365638117720309179805762862135")
CF("63245986/102334155")
print[[
[0;1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,...
]]
CF("1.414213562373095048801688724209698078569671875376948073176")
print[[
[1;2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,...
]]

CF("3.141592653589793238462643383279502884197169399375105820974")
print[[
[3,7,15,1,292,1,1,1,2,1,3,1,14,2,1,1,2,2,2,2,1,84,2,1,1,15,3,13,1,4,2,6,6,99,1,2,2,6,3,5,1,1,6,8,1,7,1,2,3,7,1,2,1,1,12,1,1,1,3,1,1,8,1,1,2,1,6,1,1,5,2,2,3,1,2,4,4,16,1,161,45,1,22,1,2,2,1,4,1,2,24,1,2,1,3,1,2,1]
]]

CF("2.718281828459045235360287471352662497757247093699959574966")
print[[
[2;1,2,1,1,4,1,1,6,1,1,8,1,1,10,1,1,12,1,1,14,1,1,16,1,1,18,1,1,20,1,1,22,1,1,24,1,1,26,1,1,28,1,1,30,1,1,32,1,1,34,1,1,36,1,1,38,1,1,40,1,1,42,1,1,44,1,1,46,1,1,48,1,1,50,1,1,52,1,1,54,1,1,56,1,1,58,1,1,60,1,1,62,1,1,64,1,1,66,1,1,68,
]]

------------------------------------------------------------------------------
print(Q.version)
