/*
* proxy.c
* token filter for ltokenp
* Luiz Henrique de Figueiredo <lhf@tecgraf.puc-rio.br>
* 18 Dec 2024 07:43:19
* This code is hereby placed in the public domain and also under the MIT license
*/

#include "ltokenp.h"

static void callback(lua_State *L, int line, int token, const char *text, const char *value)
{
 lua_getglobal(L,FILTER);
 lua_pushinteger(L,line);
 lua_pushinteger(L,token);
 lua_pushstring(L,text);
 lua_pushstring(L,value);
 lua_call(L,4,0);
}

#if LUA_VERSION_NUM < 503
#define TK_INT	(-1)
#define TK_FLT	TK_NUMBER
#endif

static int filter(LexState *X, SemInfo *seminfo)
{
 lua_State *L=X->L;
 callback(L,0,-1,"<file>",getstr(X->source));
 for (;;)
 {
  const char *text;
  const char *value;
  int t=llex(X,seminfo);
  char s[2];
  if (t<FIRST_RESERVED)
  {
   s[0]=t; s[1]=0;
   text=s;
  }
  else
   text=luaX_tokens[t-FIRST_RESERVED];
  switch (t)
  {
    case TK_STRING:
    case TK_NAME:
     value=getstr(seminfo->ts);
     break;
    case TK_INT:
    case TK_FLT:
     value=X->buff->buffer;
     break;
    default:
     value=text;
     break;
  }
  callback(L,X->linenumber,t,text,value);
  if (t==TK_EOS) return t;
 }
}

static int nexttoken(LexState *X, SemInfo *seminfo)
{
 if (FILTERING)
  return filter(X,seminfo);
 else
  return llex(X,seminfo);
}

#define llex nexttoken
