/* Image Processing and Recognition Module for the IUPGLCAP application. */

#ifdef WIN32            
#include <windows.h>    /* necessary because of the Microsoft OpenGL headers dependency */
#endif

#include <GL/gl.h>

#include <stdio.h>
#include <stdlib.h>

#include <im.h>
#include <im_image.h>
#include <im_convert.h>
#include <im_process.h>
#include <im_colorhsi.h>

#include "ARProcess.h"


void ConvertGLData2Luminance(unsigned char* gl_data, imImage* image)
{
  int i;
  unsigned char* im_data = (unsigned char*)image->data[0];
  for (i = 0; i < image->count; i++)
  {
    *im_data++ = (unsigned char)( 0.2999*(*gl_data) + 0.587*(*(gl_data+1)) + 0.114*(*(gl_data+2)) );
    gl_data += 3;
  }
}


/* converts 0-1 to 0-255 for OpenGL display. */
static void FixGray(imImage* image)
{
  int i;
  unsigned char* im_data = (unsigned char*)image->data[0];
  for (i = 0; i < image->count; i++)
  {
    if (*im_data)
      *im_data = 255;
    im_data++;
  }
}

static int centroid_x = -1, centroid_y = -1;

static void FindRedCentroid(unsigned char* gl_data, imImage *image)
{
  unsigned char r, g, b;
  float h, s, i;
  int x, y, N = 0;
  unsigned char* im_data = (unsigned char*)image->data[0];

  centroid_x = 0;
  centroid_y = 0;

  for (y = 0; y < image->height; y++)
  {
    for (x = 0; x < image->width; x++)
    {
      r = *gl_data;
      g = *(gl_data+1);
      b = *(gl_data+2);

      /* check for red mark */
      if (r > 150 && g < 150 && b < 150)
      {
        imColorRGB2HSIbyte(r, g, b, &h, &s, &i);
        if ((h < 15 || h > 345) && (s > 0.3) && (i > 0.3))
        {
          *im_data = 255;
          centroid_x += x;
          centroid_y += y;
          N++;
        }
        else
          *im_data = 0;
      }
      else
        *im_data = 0;

      im_data++;
      gl_data += 3;
    }
  }

  if (N)
  {
    centroid_x /= N;
    centroid_y /= N;
  }
  else
  {
    centroid_x = -1;
    centroid_y = -1;
  }
}

/* called when the image is allocated, or reallocated when size is changed.
 */
void arReset(imImage* image, int *flags, double value1, double value2)
{
}

/* Process the image 
 * gl_data - right image in OpenGL format
 * image - left image ( in gray scale - IM_GRAY);
 * user_flags[3] - three interface flags;
 * user_value1, user_value2 - real values controled by the user valuators [0,1].
 */
void arProcess(unsigned char* gl_data, imImage *image, int *flags, double value1, double value2)
{
  if (flags[0])
  {
//    ConvertGLData2Luminance(app_data->gl_data, app_data->image);

    FindRedCentroid(gl_data, image);

//    FixGray(image);
  }
}

/* repaint called after each image is drawn on the respective canvas
 */
void arRepaint(int left, int *flags, double value1, double value2)
{
  if (left && flags[0])
  {
    if (centroid_x != -1 && centroid_y != -1)
    {
      glBegin(GL_LINES);
      glVertex2i(centroid_x-10, centroid_y);
      glVertex2i(centroid_x+10, centroid_y);
      glVertex2i(centroid_x, centroid_y-10);
      glVertex2i(centroid_x, centroid_y+10);
      glEnd();
    }
  }
}

/* release internal module memory
 */
void arRelease(void)
{
}

