---------------------------------------------------------------------
-- This program converts from Tecgraf's WebBook to HTML Help Project Files.
-- by Mark Stroetzel Glasberg and Antonio Scuri
-- 09 Dec, 2004
---------------------------------------------------------------------

languages_description = {
  en = "0x0409 English - United States",
  es = "0x040A Spanish - Standard",
  fr = "0x040C French - Standard", 
  de = "0x0407 German - Standard", 
--  pt = "0x0816 Portuguese - Standard",
  pt = "0x0416 Portuguese - Brazil",
  it = "0x0410 Italian - Standard"
}

-- INITIALIZATION ---------------------------------------------------

function isinlist(lng, list)
  local i = 1
  local n = #list
  while i <= n do
    if list[i] == lng then
      return 1
    end
    i = i + 1;
  end
  return nil
end

-- BASIC FUNCTIONS --------------------------------------------------

function out(string)
  file:write(string)
end

function outln(string)
  local i = ident + 1
  while i>0 do
    file:write("  ")
    i = i - 1
  end
  file:write(string.."\n")
end

-- HHP FILE FUNCTIONS ------------------------------------------------

files = {}

function add2files(v)
  if v then
    -- only up to "#"
    local j = string.find(v, "#")
    if j then
      f = string.sub(v, 0, j-1)
    else
      f = v
    end
  
    files[f] = f
  end
end

function writehhpheader()
  out("[OPTIONS]\n")
  outln("Binary Index=No")
  outln("Compatibility=1.0")
  outln("Compiled file=" .. wb_usr.file_title .. "_" .. lng .. ".chm")
  outln("Contents file=wb_tree" .. "_" .. lng .. ".hhc")
  outln("Default topic=" .. lng .. "/" .. wb_usr.tree.link)
  outln("Display compile notes=Yes")
  outln("Display compile progress=Yes")
  outln("Full-text search=Yes")
  outln("Language="..languages_description[lng])
  outln("Title="..wb_usr.messages[lng].title)
  out("\n")
  out("[FILES]\n")
  outln(lng .. "/" .. wb_usr.tree.link)
end

function writehhpfooter()
  local tmp = [[
[INFOTYPES]
  ]]
  out(tmp)
end

function writehhpcenter()
  if (not files) then return end
  
  local v = next(files, nil)
  while v ~= nil do
    outln(dir..v)
    v = next(files, v)
  end
end

function writehhp()
  writehhpheader()
  writehhpcenter()
  writehhpfooter()
end


-- HHC FILE FUNCTIONS ------------------------------------------------

function writeheader()
  out("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n")
  out("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n")
  out("<HTML>\n")
  out("<HEAD>\n")
  out("<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">\n")
  out("<!-- Sitemap 1.0 -->\n")
  out("<!-- Generated by WebBook -->\n")
  out("</HEAD><BODY>\n")
  out("  <UL>\n")
  out("  <LI> <OBJECT type=\"text/sitemap\">\n")
  out("       <param name=\"Name\" value=\""..wb_usr.messages[lng].title.."\">\n")
  out("       <param name=\"Local\" value=\""..lng .. "/" .. wb_usr.tree.link .. "\">\n")
  out("       </OBJECT>\n")
end

function type_string (o) 
  return type(o) == "string" 
end

function writeend()
  out("  </UL>\n")
  out("</BODY>\n")
  out("</HTML>\n")
end

function writesubitems(tree, mainlink)
  if (not tree) then
    return
  end
  local i = 1
  local n = #tree
  while i <= n do
    writetopic(tree[i], mainlink)
    i = i + 1
  end
  ident = ident - 1
end

-- mainlink is the link of the father -> if no link is specified
-- this is the one that is used.
function writetopic(t, mainlink)
  local link
  local topic_name

  add2files(mainlink)

  if t.name == nil then 
    print("ERROR: Title is nil.")
    return
  end

  if (t.name[lng]) then
    topic_name = t.name[lng]
  else
    topic_name = t.name["nl"]
  end

  if topic_name == nil then 
    print("ERROR: Title is nil in language [" .. lng .. "].")
    return
  end

  if t.link and t.link ~= "" then
    link = t.link
  else
    link = nil
  end
 
  add2files(link)
  
  if t.bookmark then
    if link == nil and mainlink == nil then
      print("Error saving bookmark!!!")
      return
    end

    if link then
      linkB = link .. "#" .. t.bookmark
    else
      linkB = mainlink .. "#" .. t.bookmark
    end
  else
    linkB = nil
  end

  outln("<LI> <OBJECT type=\"text/sitemap\">")
  outln("<param name=\"Name\" value=\""..topic_name.."\">")
  if linkB then
    outln("<param name=\"Local\" value=\""..dir..linkB.."\">")
  else
    if link then
      outln("<param name=\"Local\" value=\""..dir..link.."\">")
    end
  end
  if useimage == 1 then
    if t.folder then
      if ident == 0 then
        outln("<param name=\"ImageNumber\" value=\"1\">")
      else
        outln("<param name=\"ImageNumber\" value=\"6\">")
      end
    else
      outln("<param name=\"ImageNumber\" value=\"11\">")
    end
  end
  outln("</OBJECT>")

  -- Write folder --
  if t.folder then
    ident = ident + 1
    outln("<UL>")
    if link == nil then
      writesubitems(t.folder, mainlink)
    else
      writesubitems(t.folder, link)
    end
    outln("</UL>")
  end

end

function writetopics(tree)
  if (not tree) then return end
  local i = 1;
  local n = #tree
  while i <= n do
    outln("<UL>")
    writetopic(tree[i], nil)
    outln("</UL>")
    i = i + 1
  end
end

-- MAIN -------------------------------------------------------------

-- lng -> from the command line

dofile("wb_usr.lua")

if (not arg[1]) then
  error("Missing language parameter.")
end
              
lng = arg[1]
dir   = lng.."/"
ident = 0
useimage = 1 -- Use images based on given information
file = nil

print("Writing \"wb_tree" .. "_" .. lng .. ".hhc\" file.")
file = io.open("wb_tree" .. "_" .. lng .. ".hhc", "w")
writeheader()
writetopics(wb_usr.tree.folder)
writeend()
file:close()

if ident ~= 0 then
  print("Ident not correct!")
end

print("Writing \"wb" .. "_" .. lng .. ".hhp\" file.")
file = io.open("wb" .. "_" .. lng .. ".hhp", "w")
writehhp()
file:close()

print("done.")

