/*
 * IterDemo.java
 *
 * Created on 29 de Abril de 2006, 12:26
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package iterator;

/*
The Design Patterns Java Companion
Copyright (C) 1998, by James W. Cooper
IBM Thomas J. Watson Research Center
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

//=========================================

public class IterDemo extends JFrame implements ActionListener {
    JawtList kidList, kidClubList;
    JTextField tx;
    JButton Get;
    KidData kdata;
    
    public IterDemo() {
        super("Enumeration demo");
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        
        JPanel jp = new JPanel();
        getContentPane().add(jp);
        jp.setLayout(new GridLayout(1, 2));
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        jp.add(left);
        jp.add(right);
        left.setBorder(new EmptyBorder(5, 5, 5, 5));
        right.setBorder(new EmptyBorder(5, 5, 5, 5));
        kidList = new JawtList(20);
        left.setLayout(new BorderLayout());
        left.add("Center", kidList);
        right.setLayout(new BorderLayout());
        tx = new JTextField(10);
        Get = new JButton("Get");
        Get.addActionListener(this);
        JPanel rtop = new JPanel();
        right.add("North", rtop);
        rtop.add(tx);
        rtop.add(Get);
        kidClubList = new JawtList(20);
        right.add("Center", kidClubList);
        kdata = new KidData("50free.txt");
        fillKidList();
        setSize(new Dimension(400, 300));
        setVisible(true);
    }
    
    private void fillKidList() {
        Enumeration ekid = kdata.elements();
        while (ekid.hasMoreElements()) {
            Kid k = (Kid) ekid.nextElement();
            kidList.add(k.getFrname() + " " + k.getLname());
    }
    }
    
    public void actionPerformed(ActionEvent e) {
        String nome;
        String club = tx.getText();
        if (club.trim().length() > 0) {
//          Enumeration eclub = kdata.kidsInClub(club);
            Enumeration eclub = kdata.kidsEmOrdemAlfabetica(club);
            while (eclub.hasMoreElements()) {
//                Kid k = (Kid) eclub.nextElement();
//                kidClubList.add(k.getFrname() + " " + k.getLname());
            nome = (String) eclub.nextElement();
            kidClubList.add(nome);
            }
        }
    }
    
    static public void main(String argv[]) {
        new IterDemo();
    }
}

//=========================================

interface awtList {
    public void add(String s);
    public void remove(String s);
    public String[] getSelectedItems();
}

//=========================================

class JawtList extends JScrollPane implements ListSelectionListener, awtList {
    private JList listWindow;
    private JListData listContents;
    
    public JawtList(int rows) {
        listContents = new JListData();
        listWindow = new JList(listContents);
        listWindow.setPrototypeCellValue("Abcdefg Hijkmnop");
        getViewport().add(listWindow);
    }
    
    public void add(String s) {
        listContents.addElement(s);
    }

    public void remove(String s) {
        listContents.removeElement(s);
    }
    
    public void clear() {
        listContents.clear();
    }
    
    public String[] getSelectedItems() {
        Object[] obj = listWindow.getSelectedValues();
        String[] s = new String[obj.length];
        for (int i = 0; i < obj.length; i++)
            s[i] = obj[i].toString();
        return s;
    }
    
    public void valueChanged(ListSelectionEvent e) {
    }
    
}

//=========================================

class JListData extends AbstractListModel {
    private Vector data;
    
    public JListData() {
        data = new Vector();
    }

    public int getSize() {
        return data.size();
    }
    
    public Object getElementAt(int index) {
        return data.elementAt(index);
    }
    
    public void addElement(String s) {
        data.addElement(s);
        fireIntervalAdded(this, data.size() - 1, data.size());
    }
    
    public void removeElement(String s) {
        data.removeElement(s);
        fireIntervalRemoved(this, 0, data.size());
    }
    
    public void clear() {
        int size = data.size();
        data = new Vector();
        fireIntervalRemoved(this, 0, size);
    }
}

//=========================================

class KidData {
    Vector kids;
    
    public KidData(String filename) {
        kids = new Vector();
        InputFile f = new InputFile(filename);
        String s = f.readLine();
        while (s != null) {
            if (s.trim().length() > 0) {
                Kid k = new Kid(s);
                kids.addElement(k);
            }
            s = f.readLine();
        }
    }
    
    public Enumeration elements() {
        return kids.elements();
    }
    
    public Enumeration kidsInClub(String club) {
        return new kidClub(this, club);
    }
    
    public Enumeration kidsEmOrdemAlfabetica (String club){
        return new ordemAlfabetica(this, club);
    }
    
    public int size() {
        return kids.size();
    }
    
    public Kid[] getData() {
        Kid[] kd = new Kid[kids.size()];
        for (int i = 0; i < kids.size(); i++)
            kd[i] = (Kid) kids.elementAt(i);
        return kd;
    }
    
    public Kid getKid(int i) {
        return (Kid) kids.elementAt(i);
    }
    
    public Vector getKidData(int key) {
        Vector v = new Vector();
        for (int i = 0; i < kids.size(); i++)
            v.addElement(getKid(i).getData(key));
        return v;
    }
    
    public int getTableKey(String tabName) {
        int key = -1;
        tabName = tabName.toLowerCase();
        if (tabName.equals("frname"))
            key = ParseVar.FRNAME;
        if (tabName.equals("lname"))
            key = ParseVar.LNAME;
        if (tabName.equals("age"))
            key = ParseVar.AGE;
        if (tabName.equals("club"))
            key = ParseVar.CLUB;
        if (tabName.equals("time"))
            key = ParseVar.TIME;
        return key;
    }
    
    public String getTableName(int i) {
        String name = "";
        switch (i) {
            case ParseVar.FRNAME:
                name = "frname";
            case ParseVar.LNAME:
                name = "lname";
            case ParseVar.AGE:
                name = "age";
            case ParseVar.CLUB:
                name = "club";
            case ParseVar.TIME:
                name = "time";
        }
        return name;
    }
}

//=========================================

class ParseObject {
    public static final int VERB = 1000, VAR = 1010, MULTVAR = 1020;
    protected int value;
    protected int type;
    
    public int getValue() {
        return value;
    }
    
    public int getType() {
        return type;
    }
}

//=========================================

class ParseVar extends ParseObject {
    static final int FRNAME = 0, LNAME = 1, AGE = 2, CLUB = 3, TIME = 4, tabMAX = 5;
    
    public ParseVar(String s) {
        s = s.toLowerCase();
        value = -1;
        type = VAR;
        if (s.equals("frname"))
            value = FRNAME;
        if (s.equals("lname"))
            value = LNAME;
        if (s.equals("age"))
            value = AGE;
        if (s.equals("club"))
            value = CLUB;
        if (s.equals("time"))
            value = TIME;
    }
    
    public boolean isLegal() {
        return (value >= 0);
    }
}

//=========================================

class Kid {
    String frname, lname, club;
    int age;
    float time;
    
    public Kid(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        String lnum = tok.nextToken();
        frname = tok.nextToken();
        lname = tok.nextToken();
        age = new Integer(tok.nextToken()).intValue();
        club = tok.nextToken();
        time = new Float(tok.nextToken()).floatValue();
    }

    public Object getData(int key) {
        switch (key) {
            case ParseVar.FRNAME:
                return frname;
            case ParseVar.LNAME:
                return lname;
            case ParseVar.CLUB:
                return club;
            case ParseVar.AGE:
                return new Integer(age);
            case ParseVar.TIME:
                return new Float(time);
        }
        return null;
    }
    
    public int getAge() {
        return age;
    }
    
    public float getTime() {
        return time;
    }
    
    public String getFrname() {
        return frname;
    }
    
    public String getLname() {
        return lname;
    }  
    
    public String getClub() {
        return club;
    }
}

//=========================================

class InputFile {
    RandomAccessFile f = null;
    boolean errflag;
    String s = null;
    
    public InputFile(String fname) {
        errflag = false;
        try {
            //open file
            f = new RandomAccessFile(fname, "r");
        } catch (IOException e) {
            //print error if not found
            System.out.println("no file found");
            errflag = true; //and set flag
        }
    }
    
    public boolean checkErr() {
        return errflag;
    }
    
    public String read() {
        //read a single field up to a comma or end of line
        String ret = "";
        if (s == null) //if no data in string
        {
            s = readLine(); //read next line
        }
        if (s != null) //if there is data
        {
            s.trim(); //trim off blanks
            int i = s.indexOf(","); //find next comma
            if (i <= 0) {
                ret = s.trim(); //if no commas go to end of line
                s = null; //and null out stored string
            } else {
                ret = s.substring(0, i).trim(); //return left of comma
                s = s.substring(i + 1); //save right of comma
            }
        } else
            ret = null;
        return ret; //return string
    }
    
    public String readLine() {
        //read in a line from the file
        s = null;
        try {
            s = f.readLine(); //could throw error
        } catch (IOException e) {
            errflag = true;
            System.out.println("File read error");
        }
        return s;
    }
    
    public void close() {
        try {
            f.close(); //close file
        } catch (IOException e) {
            System.out.println("File close error");
            errflag = true;
        }
    }
}

//=========================================

class kidClub implements Enumeration {
    String clubMask; //name of club
    Kid kid; //next kid to return
    Enumeration ke; //gets all kids
    KidData kdata; //class containing kids
    
    
    public kidClub(KidData kd, String club) {
        clubMask = club; //save the club
        kdata = kd; //copy the class
        kid = null; //default
        ke = kdata.elements(); //get Enumerator
    }
    
    public boolean hasMoreElements() {
        //return true if there are any more kids
        //belonging to the specified club
        boolean found = false;
        while (ke.hasMoreElements() && !found) {
            kid = (Kid) ke.nextElement();
            found = kid.getClub().equals(clubMask);
        }
        if (!found)
            kid = null; //set to null if none left
        return found;
    }
    
    public Object nextElement() {
        if (kid != null)
            return kid;
        else
            //throw exception if access past end
            throw new NoSuchElementException();
    }
}

//=========================================

class ordemAlfabetica implements Enumeration {

    String clubMask; //name of club
    Kid kid; //next kid to return
    Enumeration ke; //gets all kids
    KidData kdata; //class containing kids
    
    String nome;
    Vector v;
    
    private int i;

    public ordemAlfabetica(KidData kd, String club) {
        
        clubMask = club; //save the club
        kdata = kd; //copy the class
        kid = null; //default
 //     ke = kdata.elements(); //get Enumerator
        
        nome = null; //default
 
       //Prepara Vetor
        v = new Vector();
        for (int i = 0; i < kdata.size(); i++)
           //Preenche vetor com primeiro nome, ltimo nome e clube
            v.addElement(kdata.getKid(i).getFrname() + " " + kdata.getKid(i).getLname() + " - " + 
                         kdata.getKid(i).getClub());
        Collections.sort(v);
        ke = v.elements();
    }
    
    public boolean hasMoreElements() {
        //return true if there are any more kids
        //belonging to the specified club
        boolean found = false;
        
        while (ke.hasMoreElements() && !found) {
            nome = (String) ke.nextElement();
            found = nome.contains(clubMask);
        }
        
        if (!found)
            nome = null; //set to null if none left
        return found;
    }  
   
    public Object nextElement() {
        if (nome != null)
            return nome;
        else
            //throw exception if access past end
            throw new NoSuchElementException();
    }
}

