package votacao;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JFrame;

// Classe Fatia
class Fatia {
    double value;
    Color color;
    
    public Fatia(double value, Color color) {
        this.value = value;
        this.color = color;
    }
}

public class JPerspectivaGraficaVotacao extends JFrame implements Observer {

    private Votacao v;
    
    JPerspectivaGraficaVotacao() {
        getContentPane().add(new GraficoPizza());
        setBounds(300, 300, 300, 300);
        Votacao v = new Votacao();
    }

    public void update(Observable o, Object arg) {
        int[] valores = null;
        o = v;
        valores[0] = v.getQtdVotos1();
        valores[1] = v.getQtdVotos2();
        valores[2] = v.getQtdVotos3();
        valores[3] = v.getQtdVotos4();
        GraficoPizza graf = new GraficoPizza(valores);
    }
}

// Classe GraficoPizza
class GraficoPizza extends JComponent {
    Fatia[] fatias = null;
    
    GraficoPizza() {
        fatias = new Fatia[4];
        fatias[0] = new Fatia(25, Color.red);
        fatias[1] = new Fatia(25, Color.green);
        fatias[2] = new Fatia(25, Color.pink);
        fatias[3] = new Fatia(25, Color.blue);
    }
    
    GraficoPizza(int[] valores) {
        fatias = new Fatia[valores.length];
        for (int i = 0; i < fatias.length; i++) {
            this.fatias[i] = new Fatia(valores[i], Color.red);
        }
    }
    
    // fatias is an array of values that represent the size of each slice.
    public void drawPie(Graphics2D g, Rectangle area, Fatia[] slices) {
        // Get total value of all fatias
        double total = 0.0D;
        for (int i=0; i<slices.length; i++) {
            total += slices[i].value;
        }
        
        // Draw each pie slice
        double curValue = 0.0D;
        int startAngle = 0;
        for (int i=0; i<slices.length; i++) {
            // Compute the start and stop angles
            startAngle = (int)(curValue * 360 / total);
            int arcAngle = (int)(slices[i].value * 360 / total);
            
            // Ensure that rounding errors do not leave a gap between the first and last slice
            if (i == slices.length-1) {
                arcAngle = 360 - startAngle;
            }
            
            // Set the color and draw a filled arc
            g.setColor(slices[i].color);
            g.fillArc(area.x, area.y, area.width, area.height, startAngle, arcAngle);
            
            curValue += slices[i].value;
        }
    }
    
    // This method is called whenever the contents needs to be painted
    public void paint(Graphics g) {
        // Draw the pie
        drawPie((Graphics2D)g, getBounds(), fatias);
    }
}

