//package server;

import java.net.Socket;
import java.net.SocketException;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;

class  CServerListener extends Thread // FIXME: or runnable
{
	private Socket	userSocket;
	private int		userPort  ;
	private CUser	client;

	public CServerListener(Socket aUserSocket, int aUserPort) throws IOException {
		super();
		userSocket	= aUserSocket;
		userPort	= aUserPort;
	}
	public void run()
	{
		try
		{
			CWIcqServerEngine p_server = CWIcqServerEngine.getInstance();
			ObjectOutputStream userOutput = new ObjectOutputStream(userSocket.getOutputStream());
			ObjectInputStream  userInput  = new ObjectInputStream(userSocket.getInputStream());

			CMessage msg = (CMessage) userInput.readObject();

			while (msg != null){
				switch ( msg.getMessageType() )
				{
					case CMessage.CLOSE_CONNECTION: 
					{
						// close the porra toda ..
						p_server.logoutUser(msg);
						break;
					}
					case CMessage.ASK_FOR_A_LOGIN: 
					{
						client = p_server.loginUser(msg,userOutput,userInput);
						break;
					}
					case CMessage.ASK_FOR_UPDATE:
					{
						// ...
						break;
					}
					case CMessage.ASK_FOR_DELETE:
					{
						// ...
						break;
					}
					case CMessage.MESSAGE_TO_USER:
					{
						System.out.println("DEBUG");
						System.out.println(msg);
						System.out.println("--------------------");
						if (client != null) {
							if (p_server.sendMessage(new CMessage(msg))) {
								System.out.println(msg.getContent());
							}
						} else {
							System.out.println("Client not logged");
							userOutput.writeObject(new CMessage(CMessage.MESSAGE_TO_UNKNOW_USER,CMessage.MESSAGE_FROM_SERVER,"[Server]:you are not logged",CMessage.MESSAGE_TO_USER));
							userOutput.flush();
						}
						break;
					}
					default:
					{
						// Invalid message type porra so 5:50 da manha de domingo!!!
						System.out.println("AHHHHHHHHHHHHH");
						break;
					}
				}
				msg = (CMessage) userInput.readObject();
			}
			p_server.logoutUser(msg);
			userSocket.close();
		} catch (SocketException ex) {
			System.out.println(ex);
			System.out.println("Got out Socket: " + userSocket) ;
		} catch (IOException ex) {
			System.out.println(ex);
		}catch (Exception ex) {
			System.out.println(ex);
		} 
	}

}
