import java.io.BufferedReader;
import java.util.StringTokenizer;
import java.io.FileReader;
import java.io.IOException;


class  CClientManager 
{
	public final static String defaultFileName = new String("client.dat");
	private String errorMessage;

	public static void main(String[] args) // just for test porpouses ..
	{
		CClientManager cm = new CClientManager();
		cm.setupClient();
	}

	public boolean setupClient() {

		try {
			CClientEngine client = CClientEngine.getInstance();

			BufferedReader file = new BufferedReader(new FileReader(defaultFileName));
			String lineContent = file.readLine();
			StringTokenizer strToken = new StringTokenizer(lineContent);
			boolean isClientOnUse = strToken.nextToken().equalsIgnoreCase("1"); // if the user is in user..
			if (isClientOnUse) {
				errorMessage = new String("This user is already on line");
				//throw IOException(errorMessage);
				return false;
			}
			client.setName(strToken.nextToken());
			client.setId( Integer.parseInt(strToken.nextToken()) );
			client.setPassword(strToken.nextToken());

			lineContent = file.readLine();
			CClientSideUser cu = null;
			while (lineContent != null)
			{
				strToken = new StringTokenizer(lineContent);
				cu = new CClientSideUser( Integer.parseInt(strToken.nextToken()), strToken.nextToken() );
				client.addKnownUser(cu);
				lineContent = file.readLine();
			}
		} catch (IOException ex) {
			System.out.println("----ClientManager could not read Client Configurations----");
			System.out.println(ex);//.printStackTrace());
		}
		return true;
	}

	public CClientManager()	{
		errorMessage = new String("");
	}
	public String getError(){return errorMessage;}

	public void setClientOnUse(boolean flag)
	{
		return ;
	}
}
