//package server;

public class  CMessage implements java.io.Serializable
{
	public static final int MESSAGE_TO_ALL		= -1;
	public static final int MESSAGE_TO_SERVER	= -2;
	public static final int MESSAGE_FROM_SERVER	= -3;
	public static final int MESSAGE_TO_UNKNOW_USER	= -4;


	public static final int CLOSE_CONNECTION = 1;
	public static final int ASK_FOR_A_LOGIN  = 2;
	public static final int ASK_FOR_UPDATE   = 3;
	public static final int ASK_FOR_DELETE   = 4;
	public static final int MESSAGE_TO_USER  = 5;
	public static final int CREATE_USER		 = 6;
	public static final int LOGIN_OK		 = 7;
	public static final int LOGIN_FAILED	 = 8;

	private int messageType ;
	private String content  ;
	private int from, to	;

	public CMessage () {
		super();
	}
	
	public CMessage (CMessage msg) {
		from = msg.getUserFrom();
		to   = msg.getUserTo();
		content = new String(msg.getContent());
		messageType = msg.getMessageType();
	}
	public CMessage (int userFrom, int userTo, String aContent, int aMessageType) {
		from = userFrom;
		to   = userTo;
		content = new String(aContent);
		messageType = aMessageType;
	}

	public int getMessageType() {return messageType;}
	public String getContent()  {return content;}
	public int getUserFrom()	{return from;}
	public int getUserTo()	{return to;}

	public void setUserTo(int userTo)		{to = userTo;}
	public void setUserFrom(int userFrom)	{from = userFrom;}
	public void setContent(String aContent)	{content = aContent;}
	public void setMessageType(int typeId)	{messageType = typeId;}

	public String toString()
	{
		String str = "\nFrom   : " + from;
		str =  str + "\nTo     : " + to;
		str =  str + "\nContent: " + content;
		str =  str + "\nMessage Type" + messageType;
		return str;
	}

}
