//package server;

import java.sql.*;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.SQLException;
import java.io.IOException;

import java.util.Vector;

// Class User Manager
// Manage All user existants an all controler Mehtod are to Manage correctly 
// The possible Users

public class  CUserManager
{
	// Singleton controler Property!
	private static CUserManager instance = null;

    // *** modify this constants as necessary
    final static String DB_NAME			= "wicqdb";
    final static String DB_USER			= "admin";
    final static String DB_PASSWORD		= "sa";

    private final static String dbUrl	= "jdbc:odbc:" + DB_NAME;
    private Connection	connection		= null;

	private Vector		Users;

	// Singleton Factory for UserManager Class
	public static CUserManager getInstance() {
		if (instance == null) {
			instance = new CUserManager();
		}
		return instance;
	}

	// -------------------------------------------------------------------------------------------
	// I don't wont any one to Extends this class !!! so nobody has the access to Constructor Method
	// -------------------------------------------------------------------------------------------
	private CUserManager(){

		Statement sp_RetrieveAllUsers = null;

		try
		{
			// Load the sun jdbc-odbc bridge driver
			// Register JDBC/ODBC Driver in jdbc DriverManager
			// On some platforms with some java VMs, newInstance() is necessary...
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
			//Class.forName ("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();

			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);

			// Check for, and display and warnings generated by the connect
			checkForWarning( connection.getWarnings ());

			// Get the DatabaseMetaData object and display
			// some information about the connection
			//DatabaseMetaData dma = connection.getMetaData ();
			//System.out.println("\nConnected to " + dma.getURL() );
			//System.out.println("Driver       "   + dma.getDriverName() );
			//System.out.println("Version      "   + dma.getDriverVersion() );

			sp_RetrieveAllUsers = connection.createStatement();
			java.sql.ResultSet resultSet = sp_RetrieveAllUsers.executeQuery("select * from User");
			Users = new Vector();

			while (resultSet.next())	{
				Users.addElement( new CUser(resultSet.getString("userLogin"),resultSet.getString("userPassword"),resultSet.getInt("userId")));
			}
			resultSet.close();
			sp_RetrieveAllUsers.close();
			connection.close();

		} catch (SQLException ex) {
			// Error, a SQLException was generated. Display the error information
			System.out.println ("--------- SQLException caught ------------");
			try { System.out.println("Warning =   " + sp_RetrieveAllUsers.getWarnings() ); }
			catch (Exception x) {}
			// get all sql error messages in a loop
			while (ex != null)
			{
				System.out.println ("ErrorCode: " + ex.getErrorCode () );
				System.out.println ("SQLState:  " + ex.getSQLState () );
				System.out.println ("Message:   " + ex.getMessage () );
				System.out.println ("-------------------------------");
				ex = ex.getNextException();
			}
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
			//out.println("Exception: " + ex + "<BR>");
		}
	}
	public Vector getAllUsers()
	{
		return Users;
	}

	public boolean retrieveAllUsers () {
		Statement sp_RetrieveAllUsers = null;
		try {
			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);
			sp_RetrieveAllUsers = connection.createStatement();
			Vector users = new Vector();
		
			java.sql.ResultSet resultSet = sp_RetrieveAllUsers.executeQuery("select * from User");

			while (resultSet.next()) {
				Users.addElement( new CUser(resultSet.getString("userLogin"),resultSet.getString("userPassword"),resultSet.getInt("userId")));
			}
			resultSet.close();
			sp_RetrieveAllUsers.close();
			connection.close();

			for (int i=0; i <= users.size() ; i++) {
				if (getUser(((CUser)users.elementAt(i)).getId()) == null) {
					Users.addElement(users.elementAt(i));
				}
			}
			return true;
		} catch (SQLException ex) {
			ex.printStackTrace();
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
		}
		return false;
	};
	public synchronized CUser createUser(CUser auser){
		Statement sp_insertUser = null;
		try {
			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);
			sp_insertUser = connection.createStatement();
		
			java.sql.ResultSet resultSet = sp_insertUser.executeQuery("insert into user where userLogin='" + auser.getName()+"', userPassword='"+auser.getPassword()+"'" );

			resultSet.close();
			sp_insertUser.close();
			connection.close();

			retrieveAllUsers();
			return ((CUser)Users.elementAt((Users.size()-1)));
		} catch (SQLException ex) {
			ex.printStackTrace();
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
		}
		return null;
	}

	public boolean deleteUser (CUser auser) {
		Statement sp_DeleteUser = null;
		try {
			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);
			sp_DeleteUser = connection.createStatement();
		
			java.sql.ResultSet resultSet = sp_DeleteUser.executeQuery("delete from user where userId = " + auser.getId() );

			resultSet.close();
			sp_DeleteUser.close();
			connection.close();
			for (int i = 0 ; i < Users.size();i++){
				if ( ((CUser)Users.elementAt(i)).getId() == auser.getId()){
					Users.removeElementAt(i);
					return true;
				}
			}
			return false;
		} catch (SQLException ex) {
			ex.printStackTrace();
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
		}
		return false;
	}

	public synchronized boolean updateUser(CUser auser) {
		Statement sp_UpdateUser = null;
		CUser user = getUser(auser.getId());
		if (user == null) {
			return false;	// this user does not exists
		}
		user.setName(auser.getName());
		user.setPassword(auser.getPassword());
		try {
			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);
			sp_UpdateUser = connection.createStatement();
		
			java.sql.ResultSet resultSet = sp_UpdateUser.executeQuery("update from user set(userLogin='"+ auser.getName() +"',userPassword='"+auser.getPassword()+"') where userId = " + auser.getId());

			resultSet.close();
			sp_UpdateUser.close();
			connection.close();
			return true;
		} catch (SQLException ex) {
			ex.printStackTrace();
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
		}
		return false;
	}

	public CUser getUser(int id) {
		int counter;
		for (counter = 0 ; counter < Users.size() ; counter++)
		{
			if ( ((CUser)Users.elementAt(counter)).getId() == id ) 
				return (CUser)Users.elementAt(counter);
		}
		return null;
	}

	public CUser getUser(String aLogin) {
		int counter;
		for (counter = 0 ; counter < Users.size() ; counter++)
		{
			if ( ((CUser)Users.elementAt(counter)).getName().equalsIgnoreCase(aLogin) ) 
				return (CUser)Users.elementAt(counter);
		}
		return null;
	}

	public boolean checkUserAuthentication(int userID, String userPassword )
	{
		CUser user = getUser(userID);
		return (user.getPassword().equalsIgnoreCase(userPassword));
	}

	// if the user is ofline this method is invoked
	
	public boolean saveOfflineMessage(int from,int to, String message) {
		Statement sp_SaveMessage = null;
		CUser auser = getUser(to);
		if (auser == null) {
			return false;
		}
		try {
			// connect to the jdbc-odbc bridge driver
			connection = DriverManager.getConnection(dbUrl, DB_USER, DB_PASSWORD);
			sp_SaveMessage = connection.createStatement();
		
			java.sql.ResultSet resultSet = sp_SaveMessage.executeQuery("insert into MessageQueue userId = '" + to +"', Message = '" + message +"', userFromId = '"+from+"'" );

			resultSet.close();
			sp_SaveMessage.close();
			connection.close();
			return true;
		} catch (SQLException ex) {
			ex.printStackTrace();
		} catch (java.lang.Exception ex){   
			// All other types of exceptions
			ex.printStackTrace();
		}
		return false;
	}

	// needs no comments
	public synchronized boolean isUserOnline (CUser user) {
		return getUser(user.getId()).isUserOnline();
	}
		
	//-------------------------------------------------------------------
	// Check any SQL warning. Returns true if a warning occurs
	//-------------------------------------------------------------------
	private boolean checkForWarning (SQLWarning warn )
			throws SQLException, IOException
	{
		boolean result = false;

		// any warning ?
		if (warn != null)
		{
			System.out.println ("--------- SQL Warning ---------");
			result = true;
			while (warn != null)
			{
				System.out.println ("ErrorCode: " + warn.getErrorCode () );
				System.out.println ("SQLState:  " + warn.getSQLState () );
				System.out.println ("Message:   " + warn.getMessage () );
				warn = warn.getNextWarning ();
			}
		}
		return result;
	}


}
