//package server;

import java.util.Hashtable;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;

import java.io.IOException;

import java.util.Vector;

public class CWIcqServerEngine {

	// Ther can be only one serve, though, variuos server interfaces.
	// So I choosed to MakeIt a Singleton !
	private static CWIcqServerEngine instance = null;

	// User Manager Class to Control All users
	protected CUserManager	userManager	= null;

	// Server main Properties
	protected boolean		listening ;
	protected ServerSocket	socketServer;
	protected Socket		socket ;
	protected int			serverPort;

	// Default contructor
	// But also it Can not be instanciated by others
	// so It is protected !! can only be instanciated by the GetInstance Method
	// As you see my dear teacher a DO know a lot of things about OO : ) !!
	// REMARK:: it can be private but in this case, it will not be Instanciated by Derivated Calasses !!
	protected CWIcqServerEngine() {
		// ..
		userManager = CUserManager.getInstance();
		listening		= true;
		socketServer	= null;
		socket			= null;
		serverPort		= 8090;
		listening		= true;
	}

	public static CWIcqServerEngine getInstance() {
		if ( instance == null ) {
			instance = new CWIcqServerEngine();
		}
		return instance;
	}

	public void stopServer () {listening = false;}

	public boolean startServer(int aPort) {
		serverPort = aPort;
		return startServer();
	}
	// Start Socket Service
	public boolean startServer() {
		try
		{
			System.out.println("Starting Server. Port:" + serverPort + " on Localhost ");
			socketServer = new ServerSocket(serverPort);

			while (listening){
				socket = socketServer.accept();
				new CServerListener( socket, serverPort ).start(); // So here a thread stay listening ...
			}
			System.out.println("DEBUG");
			// Close Server Connection
			socketServer.close();
			return true;
		} catch (IOException ex) {
			System.out.println("deu merda no Start Server" + ex.getMessage());
		}
		return false;
	}

	//... Still developing 
	public synchronized boolean isUserOnline() {return true;} //...
	public synchronized boolean requestLogin() {return true;}
	public synchronized boolean setUserOfline() {return true;}
	public synchronized boolean setUserOnline() {return true;}

	// this is used to Server to send a message to a given user or store the massage on his message queue

	public synchronized boolean sendMessage(CMessage msg) {
		try {
			CUser user = null;
			// global message ?
			if (msg.getUserTo() == CMessage.MESSAGE_TO_ALL) { 
				System.out.println("GLOBAL MESSAGE");
				Vector temp = userManager.getAllUsers();
				for (int i=0; i < temp.size();i++) {
					user = (CUser)temp.elementAt(i) ;
					if (user.isUserOnline()) {
						user.getOutputStream().writeObject(msg);
						user.getOutputStream().flush();
					}
				}
				return true;
			}
			user = userManager.getUser(msg.getUserTo());
			if ( user.isUserOnline() ) {
				System.out.println("message to:" + user.toString() ); // FIXME: DEBUG
				user.getOutputStream().writeObject(new CMessage(msg));
				user.getOutputStream().flush();
				System.out.println("Message Sent:" + msg);
				return true;
			}
			user = userManager.getUser(msg.getUserFrom());
			user.getOutputStream().writeObject(new CMessage(CMessage.MESSAGE_FROM_SERVER,user.getId(),"[Server]: User Offline",CMessage.MESSAGE_TO_USER));
			user.getOutputStream().flush();

			userManager.saveOfflineMessage(msg.getUserFrom(),msg.getUserTo(),msg.getContent());

			System.out.println("[Server]: User offline...");
			return false;
		} catch(IOException  ex) {
			ex.printStackTrace();
		} catch (Exception ex){
			ex.printStackTrace();
		}
		return false;
	}

	public synchronized CUser loginUser(CMessage msg , ObjectOutputStream userOutput, ObjectInputStream userInput) {
		try {
			CUser aRegUSer  = userManager.getUser(msg.getUserFrom());
			if (aRegUSer == null) {
				System.out.println("[Server]:Invalid USer");
				userOutput.writeObject(new CMessage(CMessage.MESSAGE_FROM_SERVER,aRegUSer.getId(),"[Server]:Invalid Login",CMessage.MESSAGE_TO_USER));
				userOutput.flush();
				return null; 
			}
			if (aRegUSer.isUserOnline()) {
				System.out.println("[Server]:Usurio doido! j esta logado");
				aRegUSer.setOutputStream(userOutput); // FIXME 
				aRegUSer.setInputStream(userInput);   // FIXME 
				return aRegUSer;
			}
			aRegUSer.setUserOnline();
			aRegUSer.setOutputStream(userOutput);
			aRegUSer.setInputStream(userInput);
			System.out.println("[Server]:New User Online:" + aRegUSer);
			aRegUSer.getOutputStream().writeObject(new CMessage(CMessage.MESSAGE_FROM_SERVER,aRegUSer.getId(),"[Server]:Login success",CMessage.MESSAGE_TO_USER));
			aRegUSer.getOutputStream().flush();
			return aRegUSer;
		} catch (IOException ex)
		{
			System.out.println("Ai meu deus no aguento mais:" + ex);
		}
		return null;
	}
	public synchronized void logoutUser(CMessage msg) throws IOException{
		CUser aRegUSer  = userManager.getUser(msg.getUserFrom());
		aRegUSer.setUserOffLine();
		aRegUSer.getOutputStream().close();
		aRegUSer.getInputStream().close();
	}

	public synchronized  CUser createNewLogin(CUser user) {
		CUser p_user = userManager.createUser(user);
		return p_user;
	}
}
