

import java.util.Vector;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;


class CClient {
	protected Vector knownUsers;	 // a list of Known Users
	protected String name;
	protected String password;
	protected int	 id;
	protected ObjectInputStream input;
	protected ObjectOutputStream output;
	protected String ip;
	protected boolean onlineFlag;

	// Singleton stufs .....
	/*
	protected static CClient instance = null;
	public static CClient getInstance() {
		if (instance == null){
			instance = new CClient();
		}
		return instance;
	}*/

	protected CClient() {
		super();
		knownUsers = new Vector();
		name		= new String();
		password	= new String();
		id			= -1;
		input		= null;
		output		= null;
		onlineFlag  = false;
	}

	public Vector getAllKnownUsers () {
		return  knownUsers;
	}
	public boolean addKnownUser (CClientSideUser newUser){
		knownUsers.addElement(newUser);
		return true;
	}

	//  Get an user with a given Id
	public CClientSideUser getKnownUser(int userId){
		CClientSideUser returnUser;
		for (int i = 0 ; i < knownUsers.size() ;i++ ){
			returnUser = (CClientSideUser)knownUsers.elementAt(i);
			if (returnUser.getId() == userId)
				return returnUser;
		}
		return null;
	}
	//  Get an user with a given login name
	public CClientSideUser getKnownUser(String userName){
		CClientSideUser returnUser;
		for (int i = 0 ; i < knownUsers.size() ;i++ ){
			returnUser = (CClientSideUser)knownUsers.elementAt(i);
			if (returnUser.getName().equalsIgnoreCase(userName))
				return returnUser;
		}
		return null;
	}

	// Getters and Setters
	public String getName(){return name ;}
	public String getIp() {return ip;}
	public String getPassword(){return password;}
	public int    getId(){return id;}

	public boolean isUserOnline(){return onlineFlag;}
	public void setUserOnline(){onlineFlag = true;}
	public void setUserOfline(){onlineFlag = false;}

	public void setName(String aString){name = new String(aString);}
	public void setIp(String aString){ip = new String(aString);}
	public void setPassword(String aString){password = new String(aString);}
	public void setId(int aID){id = aID;}

	public String toString() {
		return new String("Id:"+ id + "  - Name:"+ name + "\nPassword:"+ password +"\n----------------");
	}

}
