import java.net.Socket;
import java.net.SocketException;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;


class CClientEngine extends CClient 
{
	private  CClientManager clientManager;

	

	protected final static String defaultStrSocket	= "localhost";
	protected final static int defaultPort			= 8090;

	protected int port;
	protected Socket socket;
	protected String strSocket;
	protected CClientSideUser currentTo;

	protected boolean done = true;

	protected static CClientEngine instance	 = null;
	public static CClientEngine getInstance() {
		if (instance == null) {
			instance = new CClientEngine();
		}
		return instance;
	}

	protected CClientEngine (){
		super();
		port	  = defaultPort;
		strSocket = defaultStrSocket;
		currentTo = null;
		done = true;
	}
	protected CClientEngine (String stringSocket, int aport){
		super();
		port		= aport;
		strSocket	= new String(stringSocket);
		currentTo   = null;
		done = true;
	}

	public static void main(String[] args) {
		try {
			CClientEngine cengine = CClientEngine.getInstance();
			cengine.initialize();
			cengine.startService();
		} catch (Exception ex) {
			System.out.println("Shii.. deu merda logo no comeo");
			ex.printStackTrace();
		}
	}

	public void initialize()
	{
		// if login ok ...
		try
		{
			clientManager = new CClientManager();
			clientManager.setupClient();

			socket = new Socket(strSocket,port);
			System.out.println(socket);
			output = new ObjectOutputStream(socket.getOutputStream());
			input  = new ObjectInputStream(socket.getInputStream()); 
			ip = socket.getInetAddress().getHostAddress();
			clientManager.setClientOnUse(true);
		} catch (IOException ex){
			System.out.println("----- Could not initilize ClientEngine -------");
			System.out.println(ex);
		}
	}
	protected CMessage getMessage()
	{
		String userCommand = getData();

		if (userCommand.equals("")){
			return null;
		}

		// if Special Message
		if(userCommand.startsWith("$",0) || (userCommand.startsWith("#",0))) {
			if(userCommand.equalsIgnoreCase("$quit"))
				return new CMessage(id, CMessage.MESSAGE_TO_SERVER , "$quit", CMessage.CLOSE_CONNECTION);  
			if(userCommand.equalsIgnoreCase("$login")) 
				return new CMessage(id, CMessage.MESSAGE_TO_SERVER , "$login", CMessage.ASK_FOR_A_LOGIN);
			if(userCommand.startsWith("#",0))
				return new CMessage(id, CMessage.MESSAGE_TO_ALL , userCommand, CMessage.MESSAGE_TO_USER);
			if(userCommand.equalsIgnoreCase("$list")) {
				System.out.println(knownUsers);
				return null;
			} 
			System.out.println("options: [ $quit | $login | $list | $help | !nameuser ] ");
			return null;
		}
		// internal messages ...
		if(userCommand.startsWith("!",0)) {
			System.out.println("Searching for:" + userCommand.substring(1, userCommand.length()) );
			currentTo = getKnownUser(userCommand.substring(1, userCommand.length()));
			System.out.println("Messages sets to:" + currentTo);
			return null;
		}
		if (currentTo != null)
			return new CMessage(id, currentTo.getId() , userCommand , CMessage.MESSAGE_TO_USER);
		else {
			// this can't be on CMD later..
			System.out.println("Choose a Friend!: [ $help ]");
			return null;
		}
		
	}

	protected String getData()
	{
		try {
			byte[] dados = new byte[255];
			String messageContent = new String("");
			boolean statusSaida = true;
			int ret = -1;
			ret = System.in.read(dados);
			return new String(dados, 0 , ret-2);
		} catch (IOException ex){
			System.out.println("----- Data could not be readed -------");
		}
		return new String("");
	}
	public synchronized void stopService(){ done = false; }

	public void startService() 
	{
		try {
			new CClientListener(input).start(); // throw our listener or Message Receaver
			while (done) {

				CMessage msg = getMessage();
				if (msg != null) {
					output.writeObject(msg);
					output.flush();
				}
			}

			output.writeObject(new CMessage(id, CMessage.MESSAGE_TO_SERVER , "$quit", CMessage.CLOSE_CONNECTION));
			output.flush();
			input.close();
			output.close();
			socket.close();
		} catch (IOException ex) {
			System.out.println("IOException :" + ex.getMessage());
		} catch (SecurityException ex) {
			System.out.println("SecurityException :" + ex.getMessage());
		} catch (NullPointerException ex) {
			System.out.println("Exceo: " + ex.getMessage());
		}
	}

}
