//package client;

import java.io.ObjectInputStream;
import java.io.IOException ;
//import server.*;

public class CClientListener extends Thread
{
	private CUser clientUser;
	private int port;
	private ObjectInputStream input;

	public CClientListener(ObjectInputStream in){
		input = in;
	}

	public void run()
	{
		// Varivel de armazenamento das mensagens de entrada
		CMessage msg;

		// Sinalizador de leitura
		try	{
			// L a primeira mensagem do canal de entrada
			msg = (CMessage) input.readObject();
			CClientEngine p_clientEngine = CClientEngine.getInstance();

			// Enquanto o servidor enviar mensagens
			while (msg != null)
			{
				System.out.println("["+ p_clientEngine.getKnownUser(msg.getUserFrom()) +"]: " + msg.getContent());
				try
				{
					// L a prxima mensagem do cliente
					msg = (CMessage) input.readObject();
				}
				catch (IOException ex) {
					System.out.println("CClientListener can not understand Message from server:" + ex);
					break;
				}
			}
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
		catch (NullPointerException ex)
		{
			System.out.println("Exceo: " + ex.getMessage());
		}
		catch (ClassNotFoundException ex)
		{
			System.out.println("Exceo: " + ex.getMessage());
		}
	}

	public synchronized boolean loginProtocol(ObjectInputStream input) {

		try {
			// L a primeira mensagem do canal de entrada
			CMessage msg = (CMessage) input.readObject();

			if (msg != null) {
				if (msg.getMessageType() == CMessage.LOGIN_OK) {
					System.out.println("Login Success!");
					return true;
				} else {
					System.out.println("Login Failed!");
				}
			}
			return false;
		}catch (ClassNotFoundException ex) {
			System.out.println(ex);
		} catch(IOException ex){
			System.out.println(ex);
		} 
		return false;
	}
}
